/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.system;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.pa.config.RemoteSystemManagerData;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.service.persist.GenericPersistence;
import com.ibm.hwmca.fw.service.persist.impl.GenericPersistenceImpl;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemProvider;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RemoteSystemManager
implements RemoteSystemStateListener {
    private static final String TRACE_MASKT = "XPARSMRT";
    private static final String TRACE_MASKF = "XPARSMRF";
    private static final String TRACE_MASKD = "XPARSMRD";
    private static RemoteSystemManager remoteSystemManager = null;
    private Set rsProviders = new HashSet();
    private static String parentKey = new String("com.ibm.hwmca.xfw.pa.system");
    private GenericPersistence pers = new GenericPersistenceImpl(parentKey);
    private Set liveSystems = new HashSet();
    private Set knownSystems = new HashSet();
    private Set rsStateListenerSet = new HashSet();
    private boolean synchronizeLive = false;

    private RemoteSystemManager(RemoteSystemManagerData rsmData, Map rsProviderMap) {
        Trace.trace(TRACE_MASKD, "--> ctor");
        if (rsmData != null) {
            Iterator nameIter = rsmData.getRMSProviderNames().iterator();
            String providerName = null;
            while (nameIter.hasNext()) {
                providerName = (String)nameIter.next();
                if (rsProviderMap.containsKey(providerName)) {
                    this.rsProviders.add(rsProviderMap.get(providerName));
                    continue;
                }
                Trace.trace(TRACE_MASKT, "Provider (" + providerName + ") not found.  Ignoring");
            }
        } else {
            Trace.trace(TRACE_MASKT, "No provider data specified.");
        }
        Trace.trace(TRACE_MASKD, "<-- ctor");
    }

    public static synchronized void configureRemoteSystemManager(RemoteSystemManagerData rsmData, Map rsProviderMap) throws HException {
        Trace.trace(TRACE_MASKD, "--> configureRemoteSystemManager");
        if (remoteSystemManager != null) {
            Trace.trace(TRACE_MASKD, "<-- configureRemoteSystemManager: erroneous reconfiguration attempted");
            throw new HException("RemoteSystemManager configuration already set.");
        }
        remoteSystemManager = new RemoteSystemManager(rsmData, rsProviderMap);
        remoteSystemManager.recoverPersistedSystems();
        remoteSystemManager.discoverLiveSystems();
        Trace.trace(TRACE_MASKD, "<-- configureRemoteSystemManager");
    }

    public static synchronized RemoteSystemManager getRemoteSystemManager() {
        return remoteSystemManager;
    }

    protected void persistSystem(RemoteSystem system) {
        try {
            Trace.trace(TRACE_MASKD, "persisting system (" + system + ";" + system.getUniqueKey() + ")");
            this.pers.store(system.getUniqueKey(), system);
        }
        catch (PersistenceException e) {
            Trace.trace(TRACE_MASKT, "persistence exception - system data not stored");
            Trace.trace(TRACE_MASKT, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverPersistedSystems() {
        try {
            List list = this.pers.load();
            Trace.trace(TRACE_MASKD, "recovered " + list.size() + " systems from persistence");
            Set set = this.knownSystems;
            synchronized (set) {
                this.knownSystems.addAll(list);
            }
        }
        catch (PersistenceException e) {
            Trace.trace(TRACE_MASKT, "persistence exception - system data not recovered");
            Trace.trace(TRACE_MASKT, e);
        }
    }

    protected void discoverLiveSystems() {
        Iterator providerIter = this.rsProviders.iterator();
        RemoteSystemProvider rsp = null;
        Set trackedSystems = null;
        Iterator systemIter = null;
        Object liveSystem = null;
        Object knownSystem = null;
        while (providerIter.hasNext()) {
            rsp = (RemoteSystemProvider)providerIter.next();
            trackedSystems = rsp.getTrackedSystems();
            systemIter = trackedSystems.iterator();
            while (systemIter.hasNext()) {
                try {
                    this.addLiveSystem((RemoteSystem)systemIter.next());
                }
                catch (HException he) {}
            }
            rsp.addRemoteSystemStateListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnownSystem(RemoteSystem system) {
        Set set = this.knownSystems;
        synchronized (set) {
            return this.knownSystems.contains(system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLiveSystem(RemoteSystem system) {
        Set set = this.liveSystems;
        synchronized (set) {
            return this.liveSystems.contains(system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addKnownSystem(RemoteSystem system) {
        Set set = this.knownSystems;
        synchronized (set) {
            if (this.isKnownSystem(system)) {
                return;
            }
            this.knownSystems.add(system);
        }
        this.persistSystem(system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteSystem addLiveSystem(RemoteSystem system) throws HException {
        if (this.isLiveSystem(system)) {
            throw new HException("System already in the live set");
        }
        Trace.trace(TRACE_MASKD, "adding live system (" + system + ";" + system.getUniqueKey() + ")");
        RemoteSystem knownSystem = this.getKnownSystem(system);
        RemoteSystem addedSystem = null;
        if (knownSystem != null) {
            addedSystem = knownSystem;
            knownSystem.liveUpdate(system);
            this.persistSystem(knownSystem);
        } else {
            addedSystem = system;
            this.addKnownSystem(addedSystem);
        }
        Set set = this.liveSystems;
        synchronized (set) {
            this.liveSystems.add(addedSystem);
        }
        this.fireRemoteSystemStateChanged(new RemoteSystemStateEvent("Add", addedSystem));
        return addedSystem;
    }

    public synchronized RemoteSystem changeLiveSystem(RemoteSystem system) throws HException {
        RemoteSystem mgrSystem = this.getLiveSystem(system);
        if (mgrSystem == null) {
            throw new HException("System not in the live set");
        }
        if (mgrSystem.getUniqueKey() != system.getUniqueKey()) {
            Trace.trace(TRACE_MASKD, "updating system (" + mgrSystem + ";" + mgrSystem.getUniqueKey() + ") from system (" + system + ";" + system.getUniqueKey() + ")");
            mgrSystem.liveUpdate(system);
        }
        this.persistSystem(mgrSystem);
        this.fireRemoteSystemStateChanged(new RemoteSystemStateEvent("Change", mgrSystem));
        return mgrSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeLiveSystem(RemoteSystem system) throws HException {
        RemoteSystem mgrSystem = this.getLiveSystem(system);
        if (mgrSystem == null) {
            throw new HException("System not in the live set");
        }
        Trace.trace(TRACE_MASKD, "removing live system (" + mgrSystem + ";" + mgrSystem.getUniqueKey() + ")");
        Set set = this.liveSystems;
        synchronized (set) {
            this.liveSystems.remove(mgrSystem);
        }
        this.fireRemoteSystemStateChanged(new RemoteSystemStateEvent("Remove", mgrSystem));
    }

    public RemoteSystem getKnownSystem(RemoteSystem system) {
        Set cloneSystems = this.getKnownSystems();
        Iterator knownIter = cloneSystems.iterator();
        RemoteSystem knownSystem = null;
        while (knownIter.hasNext()) {
            knownSystem = (RemoteSystem)knownIter.next();
            if (!system.equals(knownSystem)) continue;
            return knownSystem;
        }
        return null;
    }

    public RemoteSystem getKnownSystem(String searchKey) {
        Set cloneSystems = this.getKnownSystems();
        Iterator knownIter = cloneSystems.iterator();
        RemoteSystem knownSystem = null;
        while (knownIter.hasNext()) {
            knownSystem = (RemoteSystem)knownIter.next();
            if (!knownSystem.getUniqueKey().equals(searchKey)) continue;
            return knownSystem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getKnownSystems() {
        Set set = this.knownSystems;
        synchronized (set) {
            Trace.trace(TRACE_MASKD, "<-> getKnownSystems (" + this.knownSystems.size() + " systems)");
            return (Set)((HashSet)this.knownSystems).clone();
        }
    }

    public Set getKnownSystems(Class systemClass) {
        Set cloneSystems = this.getKnownSystems();
        Iterator sysIter = cloneSystems.iterator();
        while (sysIter.hasNext()) {
            if (systemClass.isInstance((RemoteSystem)sysIter.next())) continue;
            sysIter.remove();
        }
        Trace.trace(TRACE_MASKD, "<-> getKnownSystems (" + cloneSystems.size() + " systems)");
        return cloneSystems;
    }

    public RemoteSystem getLiveSystem(RemoteSystem system) {
        Set cloneSystems = this.getLiveSystems();
        Iterator liveIter = cloneSystems.iterator();
        RemoteSystem liveSystem = null;
        while (liveIter.hasNext()) {
            liveSystem = (RemoteSystem)liveIter.next();
            if (!system.equals(liveSystem)) continue;
            return liveSystem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getLiveSystems() {
        Set set = this.liveSystems;
        synchronized (set) {
            Trace.trace(TRACE_MASKD, "<-> getLiveSystems (" + this.liveSystems.size() + " systems)");
            return (Set)((HashSet)this.liveSystems).clone();
        }
    }

    public Set getLiveSystems(Class systemClass) {
        Set cloneSystems = this.getLiveSystems();
        Iterator sysIter = cloneSystems.iterator();
        while (sysIter.hasNext()) {
            if (systemClass.isInstance((RemoteSystem)sysIter.next())) continue;
            sysIter.remove();
        }
        Trace.trace(TRACE_MASKD, "<-> getLiveSystems (" + cloneSystems.size() + " systems)");
        return cloneSystems;
    }

    public void remoteSystemStateChanged(RemoteSystemStateEvent rsStateEvent) {
        RemoteSystem rs = rsStateEvent.getRemoteSystem();
        if (rsStateEvent.getState() == "Add") {
            try {
                this.addLiveSystem(rs);
            }
            catch (HException he) {}
        } else if (rsStateEvent.getState() == "Change") {
            try {
                this.changeLiveSystem(rs);
            }
            catch (HException he) {}
        } else if (rsStateEvent.getState() == "Remove") {
            try {
                this.removeLiveSystem(rs);
            }
            catch (HException hException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteSystemStateListener(RemoteSystemStateListener rsStateListener) {
        Set set = this.rsStateListenerSet;
        synchronized (set) {
            this.rsStateListenerSet.add(rsStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteSystemStateListener(RemoteSystemStateListener rsStateListener) {
        Set set = this.rsStateListenerSet;
        synchronized (set) {
            this.rsStateListenerSet.remove(rsStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoteSystemStateChanged(RemoteSystemStateEvent rsStateEvent) {
        Trace.trace(TRACE_MASKD, "--> fireRemoteSystemStateChanged");
        Trace.trace(TRACE_MASKD, "firing: " + rsStateEvent);
        Set set = this.rsStateListenerSet;
        synchronized (set) {
            Iterator listenerIter = this.rsStateListenerSet.iterator();
            while (listenerIter.hasNext()) {
                ((RemoteSystemStateListener)listenerIter.next()).remoteSystemStateChanged(rsStateEvent);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- fireRemoteSystemStateChanged");
    }
}

